/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.io.File;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SoftwareComponent
extends Component {
    private String m_product;
    private String m_productHome;
    private String m_release;

    SoftwareComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        String oracleHome = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLEHOME);
        Trace.out((String)("==== ParamManager reports Oracle Home as: " + oracleHome));
        if (oracleHome != null) {
            this.m_product = "database";
            this.m_productHome = oracleHome;
            this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
            if ("10gR1".equalsIgnoreCase(this.m_release)) {
                this.m_release = "10.1";
            } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                this.m_release = "10.2";
            } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                this.m_release = "11.1";
            } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                this.m_release = "11.2";
            }
        } else {
            String home = null;
            boolean haConfigured = VerificationUtil.isHAConfigured();
            this.m_product = haConfigured ? "ha" : "crs";
            if (haConfigured) {
                home = VerificationUtil.getHAHome();
                if (home == null) {
                    throw new ComponentInitException(s_msgBundle.getMessage("5307", false));
                }
            } else {
                home = VerificationUtil.getCRSHome();
                if (home == null) {
                    throw new ComponentInitException(s_msgBundle.getMessage("5301", false));
                }
            }
            Trace.out((String)"init: Validation for comp software");
            if (haConfigured) {
                File cfgFile;
                MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
                String cfgFilePath = null;
                try {
                    cfgFilePath = VerificationUtil.getCompSoftwareConfigXmlPath();
                }
                catch (XmlFilePathException x) {
                    throw new ComponentInitException(x.getMessage());
                }
                if (cfgFilePath != null && !(cfgFile = new File(cfgFilePath)).exists()) {
                    throw new ComponentInitException(theMB.getMessage("5740", true));
                }
            }
            this.m_productHome = home;
            String activeVersion = null;
            activeVersion = haConfigured ? VerificationUtil.getSIHAReleaseVersion() : VerificationUtil.getCRSActiveVersion();
            if (activeVersion == null) {
                this.m_release = "12.1";
            } else if (activeVersion.startsWith("12.1") || activeVersion.startsWith("12.0")) {
                this.m_release = "12.1";
            } else if (activeVersion.startsWith("11.2")) {
                this.m_release = "11.2";
            } else if (activeVersion.startsWith("11.1") || activeVersion.startsWith("11.0")) {
                this.m_release = "11.1";
            } else if (activeVersion.startsWith("10.2")) {
                this.m_release = "10.2";
            } else if (activeVersion.startsWith("10.1") || activeVersion.startsWith("10.0")) {
                this.m_release = "10.1";
            }
        }
    }

    @Override
    public boolean verify() {
        String[] crsNodes = null;
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (VerificationUtil.isHAConfigured()) {
            crsNodes = validNodeArr;
        } else {
            crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
            if (null == crsNodes) {
                return false;
            }
        }
        switch (this.m_verificationType) {
            case 16: {
                TaskSoftwareDistribution taskSD = new TaskSoftwareDistribution(crsNodes);
                taskSD.setNodeList(crsNodes);
                taskSD.setSoftwareComponent(this.m_product);
                taskSD.setSoftwareComponentHome(this.m_productHome);
                taskSD.setRelease(this.m_release);
                retval &= taskSD.perform();
                Trace.out((String)"\n>>>> SoftwareDistributionComponent:: Upload taskSD >>>>>\n");
                this.m_resultSet.uploadResultSet(taskSD.getResultSet());
                return !this.m_resultSet.anyFailure();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "SOFTWARE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9966", false);
    }
}

